<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\Requests\User\UserAuth;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Requests\User\UserContent;
use Erlage\Photogram\Constants\RequestConstants;
use Erlage\Photogram\Data\Tables\User\UserTable;
use Erlage\Photogram\Requests\User\UserFieldEditor;
use Erlage\Photogram\Requests\User\Block\UserBlockActions;
use Erlage\Photogram\Requests\User\Block\UserBlockContent;
use Erlage\Photogram\Requests\User\Follow\UserFollowActions;
use Erlage\Photogram\Requests\User\Follow\UserFollowContent;
use Erlage\Photogram\Requests\User\Recovery\UserRecoveryActions;
use Erlage\Photogram\Requests\User\EmailVerification\UserEmailVerificationActions;

/*
|--------------------------------------------------------------------------
| Handle request:
|--------------------------------------------------------------------------
*/

switch (State::getReqType())
{
    /*
    |--------------------------------------------------------------------------
    | user requests
    |--------------------------------------------------------------------------
    */

    // auth

    case RequestConstants::REQ_TYPE_SESSION: UserAuth::session();

    break;

    case RequestConstants::REQ_TYPE_LOGIN: UserAuth::login();

    break;

    case RequestConstants::REQ_TYPE_LOGOUT: UserAuth::logout();

    break;

    case RequestConstants::REQ_TYPE_REGISTER: UserAuth::register();

    break;

    // content

    case RequestConstants::REQ_TYPE_USER_GLOBAL_SEARCH_LATEST:
        UserContent::search(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_USER_GLOBAL_SEARCH_BOTTOM:
        UserContent::search(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    case RequestConstants::REQ_TYPE_USER_LOAD_SINGLE: UserContent::loadSingle();

    break;

    // update

    case RequestConstants::REQ_TYPE_UPDATE_USER_DISPLAY_NAME:
        UserFieldEditor::editUserField(UserTable::DISPLAY_NAME);

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_USERNAME:
        UserFieldEditor::editUserField(UserTable::USERNAME);

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_DISPLAY_BIO:
        UserFieldEditor::editUserField(UserTable::DISPLAY_BIO);

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_DISPLAY_WEB:
        UserFieldEditor::editUserField(UserTable::DISPLAY_WEB);

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_EMAIL:
        UserFieldEditor::editUserField(UserTable::EMAIL);

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_PASSWORD:
        UserFieldEditor::updateUserPassword();

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_META_IS_PRIVATE:
        UserFieldEditor::editUserField(UserTable::META_IS_PRIVATE);

    break;

    case RequestConstants::REQ_TYPE_UPDATE_USER_META_PUSH_SETTINGS:
        UserFieldEditor::editUserField(UserTable::META_PUSH_SETTINGS);

    break;

    case RequestConstants::REQ_TYPE_REMOVE_USER_PROFILE_PICTURE:
        UserFieldEditor::removeUserProfilePicture();

    break;

    case RequestConstants::REQ_TYPE_UPLOAD_USER_PROFILE_PICTURE:
        UserFieldEditor::uploadUserProfilePicture();

    break;

    /*
    |--------------------------------------------------------------------------
    | user follow requests
    |--------------------------------------------------------------------------
    */

    // content

    // followers

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PROFILE_FOLLOWERS_LOAD_LATEST:
        UserFollowContent::userRelationships(
            ServerConstants::SERVER_CONST_FEED_TYPE_FOLLOWERS,
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PROFILE_FOLLOWERS_LOAD_BOTTOM:
        UserFollowContent::userRelationships(
            ServerConstants::SERVER_CONST_FEED_TYPE_FOLLOWERS,
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;

    // followings

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PROFILE_FOLLOWINGS_LOAD_LATEST:
        UserFollowContent::userRelationships(
            ServerConstants::SERVER_CONST_FEED_TYPE_FOLLOWINGS,
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PROFILE_FOLLOWINGS_LOAD_BOTTOM:
        UserFollowContent::userRelationships(
            ServerConstants::SERVER_CONST_FEED_TYPE_FOLLOWINGS,
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;

    // pending follow requests

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PENDING_LOAD_LATEST:
        UserFollowContent::pendingRequests(
            ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST
        );

    break;

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PENDING_LOAD_BOTTOM:
        UserFollowContent::pendingRequests(
            ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM
        );

    break;

    // get total pending count & most recent user that's in pending

    case RequestConstants::REQ_TYPE_USER_FOLLOW_PENDING_COUNT_AND_RECENT:
        UserFollowContent::pendingRequestsCount();

    break;

    // actions

    case RequestConstants::REQ_TYPE_USER_FOLLOW_ADD: UserFollowActions::add();

    break;

    case RequestConstants::REQ_TYPE_USER_FOLLOW_REMOVE: UserFollowActions::remove();

    break;

    // actions on pending requests

    case RequestConstants::REQ_TYPE_USER_FOLLOW_ACCEPT: UserFollowActions::accept();

    break;

    case RequestConstants::REQ_TYPE_USER_FOLLOW_IGNORE: UserFollowActions::ignore();

    break;

    /*
    |--------------------------------------------------------------------------
    | user block requests
    |--------------------------------------------------------------------------
    */

    // content

    case RequestConstants::REQ_TYPE_USER_BLOCK_LOAD_LATEST:
        UserBlockContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_USER_BLOCK_LOAD_BOTTOM:
        UserBlockContent::load(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    // actions

    case RequestConstants::REQ_TYPE_USER_BLOCK_ADD: UserBlockActions::add();

    break;

    case RequestConstants::REQ_TYPE_USER_BLOCK_REMOVE: UserBlockActions::remove();

    break;

    /*
    |--------------------------------------------------------------------------
    | user recovery requests
    |--------------------------------------------------------------------------
    */

    case RequestConstants::REQ_TYPE_USER_RECOVERY_START: UserRecoveryActions::start();

    break;

    case RequestConstants::REQ_TYPE_USER_RECOVERY_CONFIRM: UserRecoveryActions::confirm();

    break;

    case RequestConstants::REQ_TYPE_USER_RECOVERY_RESET_PASSWORD: UserRecoveryActions::resetPassword();

    break;

    /*
    |--------------------------------------------------------------------------
    | user email verification requests
    |--------------------------------------------------------------------------
    */

    case RequestConstants::REQ_TYPE_USER_EMAIL_VERIFICATION_START: UserEmailVerificationActions::start();

    break;

    case RequestConstants::REQ_TYPE_USER_EMAIL_VERIFICATION_CONFIRM: UserEmailVerificationActions::confirm();

    break;
}
